# שולחן העבודה של המשתמש הנוכחי
$desktop = [Environment]::GetFolderPath("Desktop")
$folder = "$desktop\PC_Report"
New-Item -ItemType Directory -Force -Path $folder

# קובץ פלט
$output = "$folder\PC_Report.txt"

"=== דוח מערכת ===" | Out-File $output -Encoding UTF8
"נוצר בתאריך: $(Get-Date)" | Out-File $output -Append -Encoding UTF8
"" | Out-File $output -Append -Encoding UTF8

# שם מחשב
"=== שם מחשב ===" | Out-File $output -Append -Encoding UTF8
$env:COMPUTERNAME | Out-File $output -Append -Encoding UTF8
"" | Out-File $output -Append -Encoding UTF8

# שם משתמש
"=== שם משתמש מחובר ===" | Out-File $output -Append -Encoding UTF8
$env:USERNAME | Out-File $output -Append -Encoding UTF8
"" | Out-File $output -Append -Encoding UTF8

# האם יש סיסמה (net user)
"=== האם למשתמש יש סיסמה ===" | Out-File $output -Append -Encoding UTF8
$netUser = net user $env:USERNAME
if ($netUser -match "Password required\s+Yes") {
    "כן, מוגדרת סיסמה" | Out-File $output -Append -Encoding UTF8
} else {
    "לא, אין סיסמה" | Out-File $output -Append -Encoding UTF8
}
"" | Out-File $output -Append -Encoding UTF8

# מערכת הפעלה
"=== מערכת הפעלה ===" | Out-File $output -Append -Encoding UTF8
(Get-WmiObject Win32_OperatingSystem).Caption | Out-File $output -Append -Encoding UTF8
"" | Out-File $output -Append -Encoding UTF8

# דיסקים ונפחים
"=== דיסקים ונפחים ===" | Out-File $output -Append -Encoding UTF8
Get-WmiObject Win32_LogicalDisk -Filter "DriveType=3" |
Select-Object DeviceID, @{Name="Size(GB)";Expression={[math]::Round($_.Size/1GB,2)}},
@{Name="Free(GB)";Expression={[math]::Round($_.FreeSpace/1GB,2)}} |
Out-File $output -Append -Encoding UTF8
"" | Out-File $output -Append -Encoding UTF8

# סוג דיסק (SSD/HDD)
"=== סוג דיסק ===" | Out-File $output -Append -Encoding UTF8
Get-WmiObject -Namespace root\Microsoft\Windows\Storage -Class MSFT_PhysicalDisk |
Select-Object FriendlyName, MediaType |
Out-File $output -Append -Encoding UTF8
"" | Out-File $output -Append -Encoding UTF8

# RAM
"=== זיכרון RAM (GB) ===" | Out-File $output -Append -Encoding UTF8
"{0:N2}" -f ((Get-WmiObject Win32_ComputerSystem).TotalPhysicalMemory / 1GB) |
Out-File $output -Append -Encoding UTF8
"" | Out-File $output -Append -Encoding UTF8

# כתובת IP
"=== כתובת IP ===" | Out-File $output -Append -Encoding UTF8
(Get-WmiObject Win32_NetworkAdapterConfiguration | Where-Object {$_.IPAddress}) |
Select-Object Description, IPAddress |
Out-File $output -Append -Encoding UTF8
"" | Out-File $output -Append -Encoding UTF8

# כרטיסי רשת + מהירות
"=== כרטיסי רשת ===" | Out-File $output -Append -Encoding UTF8
Get-WmiObject Win32_NetworkAdapter |
Where-Object { $_.NetEnabled -eq $true } |
Select-Object Name, MACAddress, Speed |
Out-File $output -Append -Encoding UTF8
"" | Out-File $output -Append -Encoding UTF8

# גרסת אופיס
"=== גרסת אופיס ===" | Out-File $output -Append -Encoding UTF8
$officeKey = "HKLM:\Software\Microsoft\Office"
if (Test-Path $officeKey) {
    Get-ChildItem $officeKey | Select-Object PSChildName |
    Out-File $output -Append -Encoding UTF8
} else {
    "לא נמצא אופיס מותקן" | Out-File $output -Append -Encoding UTF8
}
"" | Out-File $output -Append -Encoding UTF8

# רשימת תוכנות
"=== תוכנות מותקנות ===" | Out-File $output -Append -Encoding UTF8
Get-ItemProperty HKLM:\Software\Microsoft\Windows\CurrentVersion\Uninstall\* ,
                 HKLM:\Software\WOW6432Node\Microsoft\Windows\CurrentVersion\Uninstall\* |
Select-Object DisplayName, DisplayVersion, Publisher |
Out-File $output -Append -Encoding UTF8

Write-Host "הדוח נשמר בתיקייה: $folder" -ForegroundColor Green
