# נתיב לשולחן העבודה
$desktop = [Environment]::GetFolderPath("Desktop")
$output = "$desktop\PC_Info.txt"

"=== שם מחשב ===" | Out-File $output -Encoding UTF8
$env:COMPUTERNAME | Out-File $output -Append -Encoding UTF8
"" | Out-File $output -Append -Encoding UTF8

"=== שם משתמש מחובר ===" | Out-File $output -Append -Encoding UTF8
$env:USERNAME | Out-File $output -Append -Encoding UTF8
"" | Out-File $output -Append -Encoding UTF8

"=== האם למשתמש יש סיסמה ===" | Out-File $output -Append -Encoding UTF8
$user = Get-LocalUser -Name $env:USERNAME
if ($user.PasswordRequired) {
    "כן, מוגדרת סיסמה" | Out-File $output -Append -Encoding UTF8
} else {
    "לא, אין סיסמה" | Out-File $output -Append -Encoding UTF8
}
"" | Out-File $output -Append -Encoding UTF8

"=== מערכת הפעלה ===" | Out-File $output -Append -Encoding UTF8
(Get-CimInstance Win32_OperatingSystem).Caption | Out-File $output -Append -Encoding UTF8
"" | Out-File $output -Append -Encoding UTF8

"=== דיסקים ונפחים ===" | Out-File $output -Append -Encoding UTF8
Get-PSDrive -PSProvider FileSystem |
Select-Object Name, Used, Free |
Out-File $output -Append -Encoding UTF8
"" | Out-File $output -Append -Encoding UTF8

"=== זיכרון RAM (GB) ===" | Out-File $output -Append -Encoding UTF8
"{0:N2}" -f ((Get-CimInstance Win32_ComputerSystem).TotalPhysicalMemory / 1GB) |
Out-File $output -Append -Encoding UTF8
"" | Out-File $output -Append -Encoding UTF8

"=== כרטיסי רשת ===" | Out-File $output -Append -Encoding UTF8
Get-NetAdapter |
Select-Object Name, MacAddress, Status |
Out-File $output -Append -Encoding UTF8
"" | Out-File $output -Append -Encoding UTF8

"=== גרסת אופיס ===" | Out-File $output -Append -Encoding UTF8
$office = Get-ChildItem "HKLM:\SOFTWARE\Microsoft\Office" -ErrorAction SilentlyContinue |
Where-Object { $_.Name -match "ClickToRun|Office" }

if ($office) {
    $office.Name | Out-File $output -Append -Encoding UTF8
} else {
    "לא נמצא אופיס מותקן" | Out-File $output -Append -Encoding UTF8
}

Write-Host "המידע נשמר בהצלחה בקובץ: $output" -ForegroundColor Green
